<?php

// Function to log data
function logCallbackData($data) {
    file_put_contents(
        'log.txt',
        date('Y-m-d H:i:s') . " - " . $data . "\n",
        FILE_APPEND
    );
}

// Log GET parameters
if (!empty($_GET)) {
    logCallbackData("GET: " . print_r($_GET, true));
}

// Log POST parameters
if (!empty($_POST)) {
    logCallbackData("POST: " . print_r($_POST, true));
}

// Log raw input (for JSON or other payloads)
$rawInput = file_get_contents('php://input');
if (!empty($rawInput)) {
    logCallbackData("RAW: " . $rawInput);
}

// --- Withdrawal accept/reject logic ---
include ("../serive/samparka.php");

if (isset($_GET['order_number']) && isset($_GET['status']) && isset($_GET['amount'])) {
    $order_number = $_GET['order_number'];
    $status = $_GET['status'];
    $amount = floatval($_GET['amount']);

    // Accept if status is 'success', else reject and refund
    if ($status === 'success') {
        // Set withdrawal as accepted (sthiti = 1)
        $stmt = $conn->prepare("UPDATE hintegedukolli SET sthiti = 1 WHERE dharavahi = ?");
        $stmt->bind_param("s", $order_number);
        $stmt->execute();
        logCallbackData("Withdrawal accepted for order_number: $order_number");
    } else {
        // Set withdrawal as rejected (sthiti = 2)
        $stmt = $conn->prepare("UPDATE hintegedukolli SET sthiti = 2 WHERE dharavahi = ?");
        $stmt->bind_param("s", $order_number);
        $stmt->execute();
        logCallbackData("Withdrawal rejected for order_number: $order_number");

        // Refund logic
        // 1. Get balakedara from hintegedukolli
        $stmt2 = $conn->prepare("SELECT balakedara FROM hintegedukolli WHERE dharavahi = ?");
        $stmt2->bind_param("s", $order_number);
        $stmt2->execute();
        $result2 = $stmt2->get_result();
        if ($row2 = $result2->fetch_assoc()) {
            $balakedara = $row2['balakedara'];

            // 2. Get current motta from shonu_kaichila
            $stmt3 = $conn->prepare("SELECT motta FROM shonu_kaichila WHERE balakedara = ?");
            $stmt3->bind_param("s", $balakedara);
            $stmt3->execute();
            $result3 = $stmt3->get_result();
            if ($row3 = $result3->fetch_assoc()) {
                $new_motta = $row3['motta'] + $amount;

                // 3. Update motta in shonu_kaichila
                $stmt4 = $conn->prepare("UPDATE shonu_kaichila SET motta = ? WHERE balakedara = ?");
                $stmt4->bind_param("ds", $new_motta, $balakedara);
                $stmt4->execute();

                logCallbackData("Refunded ₹$amount to balakedara: $balakedara. New motta: $new_motta");
            } else {
                logCallbackData("balakedara $balakedara not found in shonu_kaichila for refund.");
            }
        } else {
            logCallbackData("Order $order_number not found in hintegedukolli for refund.");
        }
    }
}

echo "OK";
exit;
?>